/* globals logger, ftdi, importScript, printBuffer */

importScript('../util.js')

function testFtdi () {
  logger.info('-----------------------------------')
  logger.info('Test: FTDI')
  logger.info('-----------------------------------')
  logger.info('Listing all FTDI devices')
  logger.info(
    ftdi.getDeviceList({
      vendor: 0x0403,
      product: 0x6010
    })
  )
  const idx = ftdi.open({
    vendor: 0x0403,
    product: 0x6010,
    interface: 0x1 // INTERFACE_A
  })

  try {
    try {
      logger.info('Send invalid data for ftdi.write')
      ftdi.write(idx, 123)
    } catch (e) {
      logger.info(`Catched expected error: ${e.message}`)
    }

    try {
      logger.info('Send invalid data for ftdi.read')
      ftdi.read(idx, 'error')
    } catch (e) {
      logger.info(`Catched expected error: ${e.message}`)
    }

    logger.info('Setting MPSSE Mode')
    ftdi.setBitmode(idx, { bitmask: 0x0, mode: 0x0 })
    ftdi.setBitmode(idx, { bitmask: 0x0, mode: 0x2 })
    logger.info(`ErrorCode = ${ftdi.getErrorCode(idx)}`)

    logger.info('Enabling loop-back mode')
    ftdi.write(idx, [0x84])

    const testData = [0x01, 0x02, 0x03]
    logger.info('Sending loop back data')
    logger.info('testData = ')
    printBuffer(testData)
    ftdi.write(idx, testData)

    logger.info('Reading received data')
    const receivedData = ftdi.read(idx)
    logger.info('receivedData = ')
    printBuffer(receivedData)

    if (receivedData.length !== testData.length * 2) {
      throw new Error('receivedData.length !== testData.length *2')
    }
    for (let i = 0; i < testData.length; i++) {
      if (receivedData[i * 2] !== 0xfa) {
        throw new Error(`recievedData[${i * 2}] must be 0xFA`)
      }
      if (receivedData[i * 2 + 1] !== testData[i]) {
        throw new Error('receivedData[i*2 +1] !== testData[i]')
      }
    }
  } finally {
    ftdi.close(idx)
  }
}

testFtdi()
