importScript('../misc/init.js')
importScript('/lib/nvme/index.js')
;(function () {
  options.initDebugLog()

  options.logSubTest('data_validator.js')

  nvme.probeController()
  const { maxNamespaceId } = nvme.getDeviceInfo()
  const { namespaces } = nvme.identifyActiveNamespaces()
  const namespaceId = namespaces[0]

  const { totalPorts, totalmem } = utility.systemInfo()
  const { size: capacity } = nvme.getNamespaceInfo(namespaceId)
  const portMem = totalmem / totalPorts

  logger.info('testDebug', `Capacity: ${capacity}`)
  logger.info('testDebug', `Total Mem: ${totalmem}`)
  logger.info('testDebug', `Total Ports: ${totalPorts}`)
  logger.info('testDebug', `Port Mem: ${portMem}`)

  if (capacity > portMem * 0.8) {
    logger.info('SKIPPED: Insufficient memory for data validator')
    return
  }

  nvme.enableDataValidator()
  logger.info('PASS: Successfully enabled data validator')

  nvme.disableDataValidator()
  logger.info('PASS: Successfully disabled data validator')

  nvme.enableDataValidator({ nsid: namespaceId })
  logger.info(
    `PASS: Successfully enabled data validator for NSID ${namespaceId}`
  )

  nvme.disableDataValidator({ nsid: namespaceId })
  logger.info(
    `PASS: Successfully disabled data validator for NSID ${namespaceId}`
  )

  options.runNegativeTest(
    () => {
      nvme.enableDataValidator(1)
    },
    'argument "options" must be an Object',
    'when passed argument type is not Object for enableDataValidator'
  )

  options.runNegativeTest(
    () => {
      nvme.disableDataValidator(1)
    },
    'argument "options" must be an Object',
    'when passed argument type is not Object for disableDataValidator'
  )

  options.runNegativeTest(
    () => {
      nvme.enableDataValidator({ nsid: 0 })
    },
    'Invalid namespace ID',
    'when invalid namespace ID is passed'
  )

  options.runNegativeTest(
    () => {
      nvme.disableDataValidator({ nsid: 0 })
    },
    'Invalid namespace ID',
    'when invalid namespace ID is passed'
  )

  options.runNegativeTest(
    () => {
      nvme.enableDataValidator({ nsid: maxNamespaceId + 1 })
    },
    'Invalid namespace ID',
    'when invalid namespace ID is passed'
  )

  options.runNegativeTest(
    () => {
      nvme.disableDataValidator({ nsid: maxNamespaceId + 1 })
    },
    'Invalid namespace ID',
    'when invalid namespace ID is passed'
  )

  // TODO: Add a test case for inactive namespace
  // TODO: Add a test case for failed memory allocation (Use error injection)
})()
