importScript('/util.js')
importScript('/lib/nvme/index.js')
importScript('/functional/misc/init.js')
;(function () {
  options.logSubTest('test nvm dataset management command')

  nvme.probeController()
  const deviceInfo = nvme.getDeviceInfo()

  try {
    nvme.datasetManagement([{ startLba: 0, length: 8 }])
    throw new Error('Exception Not Triggered')
  } catch (e) {
    if (e.message === 'Exception Not Triggered') {
      throw new Error('expected an exception, but exception was not triggered')
    }
    logger.info(
      `PASS: Received exception, ${e.message}, when there is not valid queue.`
    )
  }

  const qid = nvme.createQueuePair()

  try {
    nvme.datasetManagement([{ startLba: 0, length: 8 }], {
      nsid: deviceInfo.maxNamespaceId + 1
    })
    throw new Error('Exception Not Triggered')
  } catch (e) {
    if (e.message === 'Exception Not Triggered') {
      throw new Error('expected an exception, but exception was not triggered')
    }
    logger.info(`PASS: Received exception, ${e.message}, with invalid NSID.`)
  }

  const nsid = 1 // TODO : Add a library that returns the last active namespace
  const namespaceInfo = nvme.getNamespaceInfo(nsid)
  const namespaceData = nvme.identifyNamespace(nsid)

  try {
    const res = nvme.datasetManagement(
      [{ startLba: namespaceInfo.size, length: 8 }],
      { nsid }
    )
    logger.info(res)
    throw new Error('Exception Not Triggered')
  } catch (e) {
    if (e.message === 'Exception Not Triggered') {
      throw new Error('expected an exception, but exception was not triggered')
    }
    logger.info(
      `PASS: Received exception, ${e.message}, with invalid start LBA.`
    )
  }

  const testLba = namespaceInfo.size - 1
  nvme.write(testLba, 1, {
    qid,
    nsid,
    dataPattern: Buffer.from([0, 1, 2, 3, 4, 5, 6, 7])
  })
  logger.info(`PASS: Successfully filled LBA ${testLba}.`)

  nvme.datasetManagement([{ startLba: testLba, length: 1 }])
  logger.info('PASS: Successfully sent NVM dataset management command')

  if ((namespaceData.data.DLFEAT & 0x7) === 0) {
    logger.info(
      'SKIP: DLFEAT[0:2] is 0. Unexpected behavior for deallocated blocks'
    )
  } else {
    const { buffer } = nvmeExt.read(qid, testLba, 1)
    for (let bufferIndex = 0; bufferIndex < buffer.length; bufferIndex++) {
      if (buffer[bufferIndex] !== 0) {
        throw new Error(
          `Reading ${testLba} did not return zeored buffer after deallocation.`
        )
      }
    }
    logger.info(`PASS: Successfully read 0 for the deallocated LBA ${testLba}.`)
  }

  nvme.datasetManagement([{ startLba: testLba, length: 1 }], { qid })
  logger.info(
    'PASS: Successfully sent NVM dataset management command with qid.'
  )

  nvme.datasetManagement([{ startLba: testLba, length: 1 }], { nsid })
  logger.info(
    'PASS: Successfully sent NVM dataset management command with NSID.'
  )

  nvme.deleteQueuePair(qid)
})()
