importScript('/util.js')
importScript('/lib/nvme/index.js')
importScript('/functional/misc/init.js')
;(function () {
  options.logSubTest('get_log_page_smart_data_io.js')

  const { smart = {} } = options.get('nvme') || {}
  const { tolerance = 0 } = smart

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const qid = nvme.createQueuePair()
  logger.info(`PASS: Successfully created a queue pair, QID: ${qid}`)

  const { size: capacity } = nvme.getNamespaceInfo(1)
  logger.info('PASS: Successfully got Namespace Capacity: ' + capacity)

  const testRead = Boolean(Date.now() % 2)
  // logger.info(`Testing ${testRead ? 'read' : 'write'} commands`)

  utility.sleep(1000) // A workround for some drives that report delayed value
  const { smart: smart1 } = nvme.getLogPageSmart()
  logger.info('PASS: Successfully executed SMART before workload')

  const workloadLoops = 1000
  const startLba = capacity - 1024
  const targetLbaRange = [startLba, startLba + 2, startLba + 4]
  const xferSize = 4096
  nvme.startWorkloadGenerator({
    nsid: 1,
    queueDepth: 1024,
    xferSize,
    loops: workloadLoops,
    range: targetLbaRange,
    readPercent: testRead ? 100 : 0,
    workload: 'random'
  })
  logger.info('PASS: Successfully accessed Data LBAs using Workload Generator')

  utility.sleep(1000) // A workround for some drives that report delayed value
  const { smart: smart2 } = nvme.getLogPageSmart()
  logger.info('PASS: Successfully executed SMART after workload')

  const expectedCmdsIssued = BigInt(targetLbaRange.length * workloadLoops)
  const expectedDataUnits =
    (expectedCmdsIssued * BigInt(xferSize)) / 512n / 1000n
  const expectedWriteCmdsIssued = testRead ? 0n : expectedCmdsIssued
  const expectedReadCmdsIssued = testRead ? expectedCmdsIssued : 0n
  const expectedWriteDataUnits = testRead ? 0n : expectedDataUnits
  const expectedReadDataUnits = testRead ? expectedDataUnits : 0n
  const actualDataWritten = smart2.dataUnitWritten - smart1.dataUnitWritten
  const actualWriteCmdsIssued = smart2.numHostWriteCmd - smart1.numHostWriteCmd
  const actualDataRead = smart2.dataUnitRead - smart1.dataUnitRead
  const actualReadCmdsIssued = smart2.numHostReadCmd - smart1.numHostReadCmd

  if (actualDataWritten !== expectedWriteDataUnits) {
    throw new Error(
      `Expected data unit written is ${expectedWriteDataUnits},` +
        `but received ${actualDataWritten}`
    )
  } else {
    logger.info(`PASS: expected data write unit == ${actualDataWritten}`)
  }

  if (actualDataRead !== expectedReadDataUnits) {
    throw new Error(
      `Expected data unit read is ${expectedReadDataUnits},` +
        `but received ${actualDataRead}`
    )
  } else {
    logger.info(`PASS: expected data read unit == ${actualDataRead}`)
  }

  if (actualWriteCmdsIssued !== expectedWriteCmdsIssued) {
    const diff = Number(actualWriteCmdsIssued - expectedWriteCmdsIssued)
    if (Math.abs(diff) > tolerance) {
      throw new Error(
        `Expect ${expectedWriteCmdsIssued} write commands,` +
          `but issued ${actualWriteCmdsIssued} commands`
      )
    }
  } else {
    logger.info(
      `PASS: expected write commands issued == ${actualWriteCmdsIssued}`
    )
  }

  if (actualReadCmdsIssued !== expectedReadCmdsIssued) {
    const diff = Number(actualReadCmdsIssued - expectedReadCmdsIssued)
    if (Math.abs(diff) > tolerance) {
      throw new Error(
        `Expect ${expectedReadCmdsIssued} read commands,` +
          `but issued ${actualReadCmdsIssued} commands`
      )
    }
  } else {
    logger.info(
      `PASS: expected read commands issued == ${actualReadCmdsIssued}`
    )
  }

  nvme.deleteQueuePair(qid)
  logger.info(
    `PASS: Succesfully deleted the previously created queue pair, QID: ${qid}`
  )
})()
