importScript('/util.js')
importScript('/functional/misc/init.js')
;(function () {
  options.logSubTest('test nvm read/write command')

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const deviceInfo = nvme.getDeviceInfo()
  logger.info('PASS: Successfully read device info')

  for (const isRead of [true, false]) {
    const rwFunc = isRead ? nvme.read : nvme.write
    const rwFuncName = isRead ? 'read' : 'write'

    try {
      rwFunc(0, 1)
      throw new Error('Exception Not Triggered')
    } catch (e) {
      if (e.message === 'Exception Not Triggered') {
        throw new Error(
          'expected an exception, but exception was not triggered'
        )
      }
      if (e.message !== 'Invalid Queue ID') {
        throw new Error(
          `expected "Invalid Queue ID", but received "${e.message}"`
        )
      }
      logger.info(
        `PASS: Received exception, "${e.message}", when there is no IO queue`
      )
    }

    const qid = nvme.createQueuePair()
    logger.info(`PASS: Successfully created a queue pair, QID = ${qid}`)

    try {
      rwFunc(0, 1, { nsid: deviceInfo.maxNamespaceId + 1 })
      throw new Error('Exception Not Triggered')
    } catch (e) {
      if (e.message === 'Exception Not Triggered') {
        throw new Error(
          'expected an exception, but exception was not triggered'
        )
      }
      if (e.message !== 'command error') {
        throw new Error(`expected "command error", but received "${e.message}"`)
      }
      logger.info(`PASS: Received exception, "${e.message}", with invalid NSID`)
    }

    // TODO: Find all valid namespaces and use the namespace with hightest nsid.
    const nsid = 1
    const namespaceInfo = nvme.getNamespaceInfo(nsid)

    try {
      rwFunc(namespaceInfo.size, 1, { nsid })
      throw new Error('Exception Not Triggered')
    } catch (e) {
      if (e.message === 'Exception Not Triggered') {
        throw new Error(
          'expected an exception, but exception was not triggered'
        )
      }
      if (e.message !== 'command error') {
        throw new Error(`expected "command error", but received "${e.message}"`)
      }
      logger.info(
        `PASS: Received exception, "${e.message}", for invalid start LBA, ${namespaceInfo.size}`
      )
    }

    try {
      rwFunc(0, 1, { invalidOption: true })
      throw new Error('Exception Not Triggered')
    } catch (e) {
      if (e.message === 'Exception Not Triggered') {
        throw new Error(
          'expected an exception, but exception was not triggered'
        )
      }
      if (!e.message.includes('is unsupported')) {
        throw new Error(`received unexpected exception "${e.message}"`)
      }
      logger.info(
        `PASS: Received exception, "${e.message}", with an invalid option.`
      )
    }

    rwFunc(namespaceInfo.size - 1, 1)
    logger.info(`PASS: Successfully sent NVM ${rwFuncName} command without qid`)

    rwFunc(0, 1, { qid })
    logger.info(`PASS: Successfully sent NVM ${rwFuncName} command with qid`)

    rwFunc(0, 1, { nsid })
    logger.info(`PASS: Successfully sent NVM ${rwFuncName} command with nsid`)

    if (rwFuncName === 'write') {
      const dataPattern = Buffer.from([0, 1, 2, 3, 4, 5, 6, 7])
      rwFunc(0, 1, { nsid, dataPattern })
      logger.info(
        `PASS: Successfully sent NVM ${rwFuncName} command with custom data pattern`
      )
    }

    nvme.deleteQueuePair(qid)
    logger.info(`PASS: Successfully deleted queue pair, ID = ${qid}`)
  }
})()
