importScript('/lib/nvme/index.js')
importScript('../misc/init.js')
;(function () {
  options.logSubTest('workload_basic.js')

  const {
    loops = 1,
    duration = 10,
    getSmart = false
  } = options.get('workload') || {}

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const result = nvme.startWorkloadGenerator({
    nsid: 1,
    queueDepth: 1024,
    xferSize: 4096,
    loops,
    readPercent: 50,
    workload: 'random',
    duration,
    features: {
      histogram: {
        enabled: true,
        startUs: 100,
        endUs: 100000,
        precisions: 4,
        rawData: true
      }
    }
  })

  const availableIoTypes = ['read', 'write', 'trim']
  const nonZeroIoTypes = ['read', 'write']
  const expectedPerfProps = ['bandwidth', 'iops', 'xfer', 'io']
  for (const io of availableIoTypes) {
    if (nonZeroIoTypes.includes(io)) {
      for (const prop of expectedPerfProps) {
        if (result[io].perf[prop] === 0) {
          throw new Error(
            `${io}.perf.${prop} from the result object should not be 0`
          )
        }
      }
    }
    if (!result[io].latency) {
      throw new Error(`${io}.latency should exists from the result object`)
    }
    if (!result[io].histogramRawData) {
      throw new Error(
        `${io}.histogramRawData should exists from the result object`
      )
    }
  }
  if (getSmart) {
    nvme.getLogPageSmart()
  }
  logger.info('PASS: Basic Workload Generator is functional')
})()
