importScript('/lib/nvme/index.js')
importScript('../misc/init.js')
;(function () {
  options.logSubTest('workload_basic_custom_pattern.js')

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const nsid = 1
  const { lbaSize } = nvme.getNamespaceInfo(nsid)

  nvme.startWorkloadGenerator({
    xferSize: lbaSize,
    range: [0],
    readPercent: 0,
    dataPattern: Buffer.from([0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11])
  })

  const qid = nvme.createQueuePair()
  const { buffer } = nvmeExt.read(qid, 0, 1)
  for (let index = 0; index < buffer.length; index++) {
    if (buffer.readUInt8(index) !== 0x11) {
      throw new Error(`Received invalid value, ${buffer.readUInt8(index)}`)
    }
  }
  logger.info('PASS: Validated data generated using custom data pattern')
  nvme.deleteQueuePair(qid)
})()
