importScript('performance/perf_lib.js')

function testPerformance () {
  logger.info('-----------------------------------')
  logger.info('Test: Performance')
  logger.info('-----------------------------------')
  logger.info('probeController()')
  nvme.probeController()

  logger.info('setting up perf.log')
  const logName = 'perf'
  const logFile = 'perf.log'
  logger.create(logName, logFile, { useTimestamp: false })

  preconditionSequentialWrite()
  measureSequentialPerformance('read', logName, 600)
  measureSequentialPerformance('write', logName, 600)

  preconditionRandomWrite()
  measureRandomPerformance('read', logName, 600)
  measureRandomPerformance('write', logName, 600)
}

testPerformance()
