/* globals logger */

function printBuffer (buf) {
  const line = 16
  let count = 0
  let str = ''
  let ascii = ''
  for (const value of buf.values()) {
    count += 1
    str += logger.sprintf('%02x ', value)
    ascii += String.fromCharCode(value <= 0x20 ? 0 : value > 0x7f ? 0 : value)
    if (count === line) {
      logger.info(str + ' ' + ascii)
      str = ''
      ascii = ''
      count = 0
    }
  }
  if (count > 0) {
    logger.info(str + ' ' + ascii)
  }
}
