function testFtdi () {
  logger.info(JSON.stringify(serialport.getDeviceList('ftdi'), null, 4))

  const { port } = utility.systemInfo()
  const idx = serialport.open('ftdi', {
    vendor: 0x0403,
    product: 0x6001,
    interface: 0x1,
    serial: `PMU-V2-${port}`,
    baudRate: 115200
  })
  serialport.send(idx, Buffer.from('\u0002pmu(pwr,on)\u0003'))

  utility.sleep(2000)
  logger.info(serialport.getReadBuffer(idx))
  serialport.close(idx)
}

testFtdi()
