function testPath () {
  logger.info('-----------------------------------')
  logger.info('Test: Path Resolution')
  logger.info('-----------------------------------')

  logger.info('importing /util.js')
  importScript('/util.js')

  let failed = false
  try {
    logger.info('running misc/circular_path.js')
    runScript('misc/circular_path.js')
  } catch (e) {
    failed = true
    logger.info(e.stack)
    logger.info(
      'expect to fail when importing a script that has circular import'
    )
  }
  if (!failed) {
    throw new Error('expected failure was not triggered')
  }

  let failedTest2 = false
  logger.info('running ../../../hello.js which is unreachable')
  try {
    runScript('../../../hello.js')
  } catch (e) {
    failedTest2 = true
    logger.info(e.stack)
    logger.info('expect to fail when running a script at an unreachable path')
  }
  if (!failedTest2) {
    throw new Error('expected failure was not triggered')
  }

  let failedTest3 = false
  logger.info('running test_notfound.js that does not exist')
  try {
    runScript('test_notfound.js')
  } catch (e) {
    failedTest3 = true
    logger.info(e.stack)
    logger.info('expect to fail when running a script that does not exist')
  }
  if (!failedTest3) {
    throw new Error('expected failure was not triggered')
  }
}

testPath()
