importScript('../misc/init.js')
;(function () {
  options.logSubTest('positive.js')

  if (!options.get('logger_power_controller_created')) {
    logger.create('power', 'power.log')
    options.set('logger_power_controller_created', true)
  }

  const peripherals = deviceManager.getSupportedPeripherals()
  if (peripherals.powerController === null) {
    logger.info('SKIPPED: No PMU device, test skipped')
    return
  }

  const manufacturer = peripherals.powerController.manufacturer

  powerController.init()
  logger.info(
    `PASS: Successfully initialized power controller. (Manufacturer: ${manufacturer})`
  )

  if (manufacturer == 'qamaestro') {
    powerController.enablePowerMonitor('power')
    logger.info('PASS: Successfully enabled power monitoring')
  }

  powerController.powerOff()
  logger.info('PASS: Successfully turn off power')

  powerController.powerOn()
  logger.info('PASS: Successfully turn on power')

  if (manufacturer == 'qamaestro') {
    powerController.disablePowerMonitor()
    logger.info('PASS: Successfully disabled power monitoring')
  }

  logger.info('PASS: Successfully uninitialized power controller')
  powerController.uninit()
})()
