/* global utility, logger */
'use strict'

const info = utility.systemInfo()

try {
  utility.createSyncSandbox(() => {
    logger.info(`first start: ${new Date()}`)
    utility.sync('first', () => {
      logger.info('in first')
      utility.sleep(1000 * (10 + info.port * 10))
    })
    logger.info(`first   end: ${new Date()}`)

    logger.info(`second start: ${new Date()}`)
    logger.info('only one port can throw')
    utility.sync('throw-err', () => {
      logger.info(`${info.hostname}-${info.port}`)
      throw new Error('intended')
    }, { exclusiveCount: 1 })
    logger.info(`second end: ${new Date()}`)

    logger.info(`third start: ${new Date()}`)
    utility.sync('third', () => {
      logger.info(`${info.hostname}-${info.port}`)
      utility.sleep(20)
    })
    logger.info(`third end: ${new Date()}`)

    logger.info(`forth start: ${new Date()}`)
    utility.sync('third', () => {
      logger.info(`${info.hostname}-${info.port}`)
      utility.sleep(20)
      throw new Error('intended2')
    }, { exclusiveCount: 1 })
    logger.info(`forth end: ${new Date()}`)

    logger.info(`5 start: ${new Date()}`)
    utility.sync('third', () => {
      logger.info(`${info.hostname}-${info.port}`)
      utility.sleep(20)
    })
    logger.info(`5 end: ${new Date()}`)
  }, { period: 60 })
} catch (e) {
  logger.info(e.toString())
  logger.info('catched exception and exit')
}
