/* global utility, logger */
importScript('../misc/init.js')
;(function () {
  options.logSubTest('sync.js')

  const { taskId } = utility.getTaskInfo()
  if (!taskId) {
    logger.info('SKIP: sync test cannot run from local mode')
    return
  }

  const info = utility.systemInfo()

  // if only one port or all ports in the same machine, this timeout will not happen
  /*
  try {
    utility.createSyncSandbox(() => { }, { period: 30, timeout: 1 })
    throw new Error('NO ERROR')
  } catch (e) {
    if (e.toString() === 'Error: NO ERROR') {
      logger.info('FAIL: expect timoeut but NO timeout')
      throw e
    }
    logger.info(`PASS: expected timeout (${e.toString()})`)
  }
  */

  try {
    utility.sync('no', () => {})
    throw new Error('NO ERROR')
  } catch (e) {
    if (e.toString() === 'Error: NO ERROR') {
      logger.info('FAIL: expect error but NO error')
      throw e
    }
    logger.info(`PASS: expected error (${e.toString()})`)
  }

  utility.createSyncSandbox(() => {
    logger.info(`first start: ${new Date()}`)
    utility.sync('first', () => {
      logger.info('in first')
      utility.sleep(1000 * (10 + info.port * 10))
    })
    logger.info(`first   end: ${new Date()}`)

    logger.info(`secondstart: ${new Date()}`)
    utility.sync('second', () => {
      logger.info('in second')
      utility.sleep(1000 * (10 + info.port * 10))
    })
    logger.info(`second  end: ${new Date()}`)

    logger.info(`third start: ${new Date()}`)
    logger.info('only one port can do it')
    utility.sync(
      'third',
      () => {
        logger.info(`${info.hostname}-${info.port}`)
      },
      { exclusiveCount: 1 }
    )
    logger.info(`third   end: ${new Date()}`)
    logger.info('PASS: simple sync tests')
  })

  try {
    utility.sync('no2', () => {})
    throw new Error('NO ERROR')
  } catch (e) {
    if (e.toString() === 'Error: NO ERROR') {
      logger.info('FAIL: expect error but NO error')
      throw e
    }
    logger.info(`PASS: expected error (${e.toString()})`)
  }

  // crash will make wrong counter state
  try {
    utility.createSyncSandbox(() => {
      logger.info(`port1 will crash start: ${new Date()}`)
      utility.sync('crash', () => {
        logger.info(info.port)
        if (info.port === 0) {
          throw new Error('Intended')
        }
      })
      logger.info(`port0 crash end: ${new Date()}`)
    })
    throw new Error('NO ERROR')
  } catch (e) {
    if (info.port === 0) {
      if (e.toString() !== 'Error: Intended') {
        logger.info(`FAIL: expect "Error: Intended" != ${e.toString()}`)
        throw e
      }
      logger.info('PASS: expected port0 exception')
    } else {
      if (e.toString() !== 'Error: NO ERROR') {
        logger.info(`FAIL: unexpected error ${e.toString()}`)
        throw e
      }
      logger.info('PASS: No exception expected port1 and others ')
    }
  }

  try {
    utility.createSyncSandbox(() => {
      utility.sync('third', () => {})
    })
    throw new Error('NO ERROR')
  } catch (e) {
    if (e.toString() === 'Error: NO ERROR') {
      logger.info('FAIL: expect error but NO error')
      throw e
    }
    if (info.port === 0) {
      if (e.toString() === 'Error: SYNC: CRASHED before third') {
        logger.info('PASS: expected crash: port1 crashed before here')
      } else {
        throw e
      }
    } else {
      if (e.toString() === 'Error: SYNC: third is ALREADY used') {
        logger.info(
          'PASS: expected exception: port1 and others already used third'
        )
      } else {
        throw e
      }
    }
  }

  try {
    utility.createSyncSandbox(() => {
      utility.createSyncSandbox(() => {
        utility.sync('hi', () => {
          logger.info('inception')
        })
      })
    })
    throw new Error('NO ERROR')
  } catch (e) {
    if (e.toString() === 'Error: NO ERROR') {
      logger.info('FAIL: expect error')
      throw e
    }
    logger.info(`PASS: expected error: No inception (${e.toString()})`)
  }
})()
