importScript('../misc/init.js')
;(function () {
  options.logSubTest('workload_basic_error.js')

  const { loops = 1, duration = 10, getSmart = false } =
    options.get('workload') || {}

  const unexpectedError = new Error('This should not be triggered')

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const deviceInfo = nvme.getDeviceInfo()

  try {
    nvme.startWorkloadGenerator({
      nsid: deviceInfo.maxNamespaceId + 1,
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('invalid namespace')) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info('PASS: Exception triggered when option.nsid is invalid')

  try {
    nvme.startWorkloadGenerator({ readPercent: 101, duration: 10 })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('0 and 100')) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception triggered when option.readPercent is greater than 100'
  )

  try {
    nvme.startWorkloadGenerator({ readPercent: -1, duration: 10 })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('0 and 100')) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception triggered when option.readPercent is less than 0'
  )

  try {
    nvme.startWorkloadGenerator({ trimPercent: 101, duration: 10 })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('0 and 100')) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception triggered when option.trimPercent is greater than 100'
  )

  try {
    nvme.startWorkloadGenerator({ trimPercent: -1, duration: 10 })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('0 and 100')) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception triggered when option.trimPercent is less than 0'
  )

  try {
    nvme.startWorkloadGenerator({ trimPercent: -1, duration: 10 })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('0 and 100')) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception triggered when option.trimPercent is less than 0'
  )

  try {
    nvme.startWorkloadGenerator({ xferSize: 511, duration: 10 })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('mutples of 512')) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception triggered when option.xferSize is not mutples of 512'
  )

  let qid
  try {
    qid = nvme.createQueuePair()
    const opc = 2 // Read
    const sc = 0x81
    const sct = 2
    nvme.setErrorInjection(qid, opc, sct, sc)
    nvme.startWorkloadGenerator({
      qid,
      xferSize: 4096,
      duration: 10,
      loops: 1,
      readPercent: 100
    })
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
    const expectedProps = ['info', 'read', 'write', 'trim', 'errorHistory']
    for (const prop of expectedProps) {
      if (!e[prop]) {
        throw new Error(`property "${prop}" does not exist`)
      }
    }
  }
  nvme.deleteQueuePair(qid)
  logger.info(
    'PASS: An error object should have info/read/write/trim/errorHistory props'
  )

  try {
    nvme.startWorkloadGenerator({
      qid: 2,
      xferSize: 4096,
      duration: 10,
      loops: 1,
      readPercent: 100
    })
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
    const expectedProps = ['info', 'read', 'write', 'trim', 'errorHistory']
    for (const prop of expectedProps) {
      if (!e[prop]) {
        throw new Error(`property "${prop}" does not exist`)
      }
    }
  }
  logger.info('PASS: Exception triggered when invalid qid is used')
})()
