importScript('../misc/init.js')
;(function () {
  options.logSubTest('workload_basic_range_list.js')

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const { size: capacity } = nvme.getNamespaceInfo(1)
  const { loops = 1000 } = options.get('workload') || {}
  const numSectors = 8
  const xferSize = numSectors * 512
  const range = [0x0, capacity / 4, capacity / 2, capacity - numSectors]
  const info = nvme.startWorkloadGenerator({
    nsid: 1,
    queueDepth: 1024,
    range,
    xferSize,
    loops
  })
  const readCount = info.read.perf.io
  const expectedCount = range.length * loops
  if (readCount !== expectedCount) {
    throw new Error(
      `Returned io counts (${readCount}) is different from expected count (${expectedCount})`
    )
  }
  logger.info('PASS: Array-based range is functional')

  const emptyListError = new Error('empty list should be error')
  try {
    nvme.startWorkloadGenerator({
      nsid: 1,
      queueDepth: 1024,
      xferSize: 4096,
      range: [],
      loops: 1,
      duration: 10
    })
    throw emptyListError
  } catch (err) {
    if (err === emptyListError) {
      throw emptyListError
    }
  }
  logger.info('PASS: Exception triggered when options.range is an empty arrary')
})()
