importScript('../misc/init.js')
;(function () {
  options.logSubTest('workload_basic_range_object.js')

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const { loops = 1, duration = 10 } = options.get('workload') || {}
  nvme.startWorkloadGenerator({
    nsid: 1,
    queueDepth: 1024,
    xferSize: 4096,
    range: { startLba: 0x1234, size: 0x5 },
    loops,
    duration
  })
  logger.info('PASS: Object-based range is functional')

  const noStartLbaError = new Error('no startLba should be error')
  try {
    nvme.startWorkloadGenerator({
      nsid: 1,
      queueDepth: 1024,
      xferSize: 4096,
      range: { size: 0x5 },
      loops: 1,
      duration: 10
    })
    throw noStartLbaError
  } catch (err) {
    if (err === noStartLbaError) {
      throw noStartLbaError
    }
  }
  logger.info(
    'PASS: Exception triggered when options.range is missing startLba'
  )

  const noSizeError = new Error('no size should be error')
  try {
    nvme.startWorkloadGenerator({
      nsid: 1,
      queueDepth: 1024,
      xferSize: 4096,
      range: { startLba: 0x5 },
      loops: 1,
      duration: 10
    })
    throw noSizeError
  } catch (err) {
    if (err === noSizeError) {
      throw noSizeError
    }
  }
  logger.info('PASS: Exception triggered when options.range is missing size')
})()
