'use strict'

const { promises: fs } = require('fs')
const counterPath = '${syncCounterPath}'

async function main () {
  const startTime = process.argv[2]
  const period = process.argv[3]

  const raw = await fs.readFile(counterPath)
  const content = raw.toString()

  try {
    const t = JSON.parse(content)

    if (toString.call(t.init) !== '[object Number]') {
      throw new Error('Need to overwrite _counter: init NOT Number')
    }
  } catch (e) {
    // json parse fail
    // not valid number in init
    await fs.writeFile(counterPath, JSON.stringify({ init: parseInt(startTime) }))
    console.log(4)
    process.exit()
  }

  const counter = JSON.parse(content)
  const now = new Date()

  // sync.init status
  // 0: all clients reaches sync time, go next
  // 1: looks like some clients slow start, we can accept 3 period time duration
  // 2: not reached sync start time, wait
  // 3: it looks old, make new _counter (it happens only reuse task id)
  // 4: counter isn't valid, make new _counter (json parse fail, init value isn't number)

  if (Object.keys(counter).length === 1) {
    if (now < counter.init) {
      // someone already init, you need to wait
      console.log(2)
    } else if ((counter.init + (3 * period)) < now) {
      // we assume it's old
      await fs.writeFile(counterPath, JSON.stringify({ init: parseInt(startTime) }))
      console.log(3)
    } else {
      // everything is clear, let's go
      console.log(0)
    }
  } else {
    if (now < counter.init) {
      // someone's timer is broken
      console.error(`TIMER IS BROKEN: ${now} < ${counter.init}`)
    } else if ((counter.init + (3 * period)) < now) {
      // we assume it's old
      // looks like old
      await fs.writeFile(counterPath, JSON.stringify({ init: parseInt(startTime) }))
      console.log(3)
    } else {
      // we assume valid init
      console.log(1)
    }
  }
}
main()
