// Generated by CoffeeScript 1.9.0
(function() {
  var JSONStorage, LocalStorage, QUOTA_EXCEEDED_ERR, StorageEvent, events, fs, path, _emptyDirectory, _rm,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __hasProp = {}.hasOwnProperty;

  path = require('path');

  fs = require('fs');

  events = require('events');

  _emptyDirectory = function(target) {
    var p, _i, _len, _ref, _results;
    _ref = fs.readdirSync(target);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      p = _ref[_i];
      _results.push(_rm(path.join(target, p)));
    }
    return _results;
  };

  _rm = function(target) {
    if (fs.statSync(target).isDirectory()) {
      _emptyDirectory(target);
      return fs.rmdirSync(target);
    } else {
      return fs.unlinkSync(target);
    }
  };

  QUOTA_EXCEEDED_ERR = (function(_super) {
    __extends(QUOTA_EXCEEDED_ERR, _super);

    function QUOTA_EXCEEDED_ERR(_at_message) {
      this.message = _at_message != null ? _at_message : 'Unknown error.';
      if (Error.captureStackTrace != null) {
        Error.captureStackTrace(this, this.constructor);
      }
      this.name = this.constructor.name;
    }

    QUOTA_EXCEEDED_ERR.prototype.toString = function() {
      return this.name + ": " + this.message;
    };

    return QUOTA_EXCEEDED_ERR;

  })(Error);

  StorageEvent = (function() {
    function StorageEvent(_at_key, _at_oldValue, _at_newValue, _at_url, _at_storageArea) {
      this.key = _at_key;
      this.oldValue = _at_oldValue;
      this.newValue = _at_newValue;
      this.url = _at_url;
      this.storageArea = _at_storageArea != null ? _at_storageArea : 'localStorage';
    }

    return StorageEvent;

  })();

  LocalStorage = (function(_super) {
    var MetaKey, createMap;

    __extends(LocalStorage, _super);

    function LocalStorage(_at_location, _at_quota) {
      this.location = _at_location;
      this.quota = _at_quota != null ? _at_quota : 5 * 1024 * 1024;
      if (!(this instanceof LocalStorage)) {
        return new LocalStorage(this.location, this.quota);
      }
      this.length = 0;
      this.bytesInUse = 0;
      this.keys = [];
      this.metaKeyMap = createMap();
      this.eventUrl = "pid:" + process.pid;
      this._init();
      this.QUOTA_EXCEEDED_ERR = QUOTA_EXCEEDED_ERR;
    }

    MetaKey = (function() {
      function MetaKey(_at_key, _at_index) {
        this.key = _at_key;
        this.index = _at_index;
        if (!(this instanceof MetaKey)) {
          return new MetaKey(this.key, this.index);
        }
      }

      return MetaKey;

    })();

    createMap = function() {
      var Map;
      Map = function() {};
      Map.prototype = Object.create(null);
      return new Map();
    };

    LocalStorage.prototype._init = function() {
      var index, k, stat, _MetaKey, _decodedKey, _i, _keys, _len;
      try {
        stat = fs.statSync(this.location);
        if ((stat != null) && !stat.isDirectory()) {
          throw new Error("A file exists at the location '" + this.location + "' when trying to create/open localStorage");
        }
        this.bytesInUse = 0;
        this.length = 0;
        _keys = fs.readdirSync(this.location);
        for (index = _i = 0, _len = _keys.length; _i < _len; index = ++_i) {
          k = _keys[index];
          _decodedKey = decodeURIComponent(k);
          this.keys.push(_decodedKey);
          _MetaKey = new MetaKey(k, index);
          this.metaKeyMap[_decodedKey] = _MetaKey;
          stat = this.getStat(k);
          if ((stat != null ? stat.size : void 0) != null) {
            _MetaKey.size = stat.size;
            this.bytesInUse += stat.size;
          }
        }
        this.length = _keys.length;
      } catch (_error) {
        fs.mkdirSync(this.location);
      }
    };

    LocalStorage.prototype.setItem = function(key, value) {
      var encodedKey, evnt, existsBeforeSet, filename, hasListeners, metaKey, oldLength, oldValue, valueString, valueStringLength;
      hasListeners = events.EventEmitter.listenerCount(this, 'storage');
      oldValue = null;
      if (hasListeners) {
        oldValue = this.getItem(key);
      }
      key = key.toString();
      encodedKey = encodeURIComponent(key);
      filename = path.join(this.location, encodedKey);
      valueString = value.toString();
      valueStringLength = valueString.length;
      metaKey = this.metaKeyMap[key];
      existsBeforeSet = !!metaKey;
      if (existsBeforeSet) {
        oldLength = metaKey.size;
      } else {
        oldLength = 0;
      }
      if (this.bytesInUse - oldLength + valueStringLength > this.quota) {
        throw new QUOTA_EXCEEDED_ERR();
      }
      fs.writeFileSync(filename, valueString, 'utf8');
      if (!existsBeforeSet) {
        metaKey = new MetaKey(encodedKey, (this.keys.push(key)) - 1);
        metaKey.size = valueStringLength;
        this.metaKeyMap[key] = metaKey;
        this.length += 1;
        this.bytesInUse += valueStringLength;
      }
      if (hasListeners) {
        evnt = new StorageEvent(key, oldValue, value, this.eventUrl);
        return this.emit('storage', evnt);
      }
    };

    LocalStorage.prototype.getItem = function(key) {
      var filename, metaKey;
      key = key.toString();
      metaKey = this.metaKeyMap[key];
      if (!!metaKey) {
        filename = path.join(this.location, metaKey.key);
        return fs.readFileSync(filename, 'utf8');
      } else {
        return null;
      }
    };

    LocalStorage.prototype.getStat = function(key) {
      var filename;
      key = key.toString();
      filename = path.join(this.location, encodeURIComponent(key));
      try {
        return fs.statSync(filename);
      } catch (_error) {
        return null;
      }
    };

    LocalStorage.prototype.removeItem = function(key) {
      var evnt, filename, hasListeners, k, meta, metaKey, oldValue, v, _ref;
      key = key.toString();
      metaKey = this.metaKeyMap[key];
      if (!!metaKey) {
        hasListeners = events.EventEmitter.listenerCount(this, 'storage');
        oldValue = null;
        if (hasListeners) {
          oldValue = this.getItem(key);
        }
        delete this.metaKeyMap[key];
        this.length -= 1;
        this.bytesInUse -= metaKey.size;
        filename = path.join(this.location, metaKey.key);
        this.keys.splice(metaKey.index, 1);
        _ref = this.metaKeyMap;
        for (k in _ref) {
          v = _ref[k];
          meta = this.metaKeyMap[k];
          if (meta.index > metaKey.index) {
            meta.index -= 1;
          }
        }
        _rm(filename);
        if (hasListeners) {
          evnt = new StorageEvent(key, oldValue, null, this.eventUrl);
          return this.emit('storage', evnt);
        }
      }
    };

    LocalStorage.prototype.key = function(n) {
      return this.keys[n];
    };

    LocalStorage.prototype.clear = function() {
      var evnt;
      _emptyDirectory(this.location);
      this.metaKeyMap = createMap();
      this.keys = [];
      this.length = 0;
      this.bytesInUse = 0;
      if (events.EventEmitter.listenerCount(this, 'storage')) {
        evnt = new StorageEvent(null, null, null, this.eventUrl);
        return this.emit('storage', evnt);
      }
    };

    LocalStorage.prototype.getBytesInUse = function() {
      return this.bytesInUse;
    };

    LocalStorage.prototype._deleteLocation = function() {
      _rm(this.location);
      this.metaKeyMap = {};
      this.keys = [];
      this.length = 0;
      return this.bytesInUse = 0;
    };

    return LocalStorage;

  })(events.EventEmitter);

  JSONStorage = (function(_super) {
    __extends(JSONStorage, _super);

    function JSONStorage() {
      return JSONStorage.__super__.constructor.apply(this, arguments);
    }

    JSONStorage.prototype.setItem = function(key, value) {
      var newValue;
      newValue = JSON.stringify(value);
      return JSONStorage.__super__.setItem.call(this, key, newValue);
    };

    JSONStorage.prototype.getItem = function(key) {
      return JSON.parse(JSONStorage.__super__.getItem.call(this, key));
    };

    return JSONStorage;

  })(LocalStorage);

  exports.LocalStorage = LocalStorage;

  exports.JSONStorage = JSONStorage;

  exports.QUOTA_EXCEEDED_ERR = QUOTA_EXCEEDED_ERR;

}).call(this);
