/* globals powerController, utility, serialport */

options = (() => {
  const options = {}
  let powerControlInit = false
  let logInit = false

  function logSubTest (subTestName, options) {
    options = options || {}
    logger.info('')
    logger.info(`Sub Test: ${subTestName}`)
    Object.keys(options).forEach(key => {
      logger.info(`- ${key}: ${JSON.stringify(options[key])}`)
    })
    logger.info('----------------------------')
  }

  function logTestSuiteStart (name, options) {
    options = options || {}
    logger.info('')
    logger.info('-----------------------------------')
    logger.info(`Test Suite: ${name} - STARTED`)
    Object.keys(options).forEach(key => {
      logger.info(`- ${key}: ${options[key]}`)
    })
    logger.info('-----------------------------------')
  }

  function logTestSuiteDone (name) {
    logger.info('')
    logger.info('-----------------------------------')
    logger.info(`Test Suite: ${name} - DONE`)
    logger.info('-----------------------------------')
  }

  function setOption (key, value) {
    options[key] = value
  }

  function getOption (key) {
    return options[key]
  }

  function openSerialPort () {
    const port = utility.systemInfo().port
    options.serialIdx = serialport.open('ftdi', {
      vendor: 0x0403,
      product: 0x6010,
      interface: 0x1, // INTERFACE_A
      serial: `AMS-V1-${port}`,
      baudRate: 115200
    })
  }

  function sendFile () {
    serialport.sendFile(options.serialIdx, 'helloworld')
  }

  function loadFile () {
    return utility.readFile('helloworld', { baseDir: 'workspace' }).toString()
  }

  function runScriptInFunction () {
    runScript('run_script.js')
    runScript('/functional/misc/run_script.js')
  }

  function runNegativeTest (func, errorMessage, errorReason) {
    try {
      func()
      throw new Error('Exception Not Triggered')
    } catch (e) {
      if (e.message === 'Exception Not Triggered') {
        throw new Error(
          'expected an exception, but exception was not triggered'
        )
      }
      if (!e.message.includes(errorMessage)) {
        throw new Error(`received unexpected exception "${e.message}"`)
      }
      logger.info(`PASS: Received exception, "${e.message}", ${errorReason}.`)
      return e
    }
  }

  function runSubTests (subTests, totalDuration) {
    for (const test of subTests) {
      test()
    }

    const t0 = Date.now()
    while (Date.now() - t0 < totalDuration * 1000) {
      subTests[Date.now() % subTests.length]()
    }
  }

  function initDebugLog () {
    if (logInit) {
      return
    }
    logger.create('testDebug', 'test_debug.log')
    logInit = true
  }

  return {
    set: setOption,
    get: getOption,
    loadFile,
    openSerialPort,
    sendFile,
    runScriptInFunction,
    logSubTest,
    logTestSuiteStart,
    logTestSuiteDone,
    runNegativeTest,
    runSubTests,
    initDebugLog
  }
})()
