'use strict'
/* global ftdi, utility */

importScript('init.js')

function powerOffFunc () {
  const port = utility.systemInfo().port

  // open device for power control
  const idx = ftdi.open({
    vendor: 0x0403,
    product: 0x6001,
    interface: 0x1, // INTERFACE_ANY
    serial: `PMU-V2-${port}` // serial number (optional)
  })

  ftdi.setBaudRate(idx, 115200)

  // power off
  ftdi.write(idx, Buffer.from('\u0002pmu(pwr,off)\u0003'))

  // close device
  ftdi.close(idx)
}

powerOffFunc()
