importScript('/functional/misc/init.js')
importScript('/lib/nvme/index.js')
;(function () {
  options.logSubTest('identify.js')

  nvme.probeController()
  logger.info('PASS: Successfully connected to NVMe controller')

  const { data: controllerData } = nvme.identifyController()
  logger.info('PASS: Successfully sent Identify Controller')

  const { namespaces: activeNamespaces } = nvme.identifyActiveNamespaces()
  logger.info(
    `PASS: Successfully received active namespaces, [${activeNamespaces}]`
  )

  const { namespaces: allocatedNamespaces } = nvme.identifyAllocatedNamespaces()
  logger.info(
    `PASS: Successfully received allocated namespaces, [${allocatedNamespaces}]`
  )

  for (let nsid = 1; nsid <= controllerData.NN; nsid++) {
    const { data } = nvme.identifyNamespace(nsid)
    logger.info(`PASS: Succesfully sent Identify Namespace with NSID ${nsid}`)
    if (data.NCAP === 0n) {
      if (activeNamespaces.includes(nsid)) {
        throw new Error(
          `Namespace ${nsid} is inactive because NCAP is 0, but Namespace ` +
            `${nsid} is in the active namespace list [${activeNamespaces}]`
        )
      } else {
        logger.info(
          `PASS: Namespace ${nsid} is inactive because NCAP is 0, ` +
            `and namespace ${nsid} is not in the active namespace list [${activeNamespaces}]`
        )
      }
    } else {
      logger.info(
        `PASS: Namespace ${nsid} is active because NCAP is non-zero (${data.NCAP}), ` +
          `and namespace ${nsid} is in the active namespace list [${activeNamespaces}]`
      )
    }

    const { controllers } = nvme.identifyActiveControllers(nsid)
    logger.info(
      `PASS: Successfully retrieved controllers [${controllers}] attached to Namespace ${nsid}`
    )
  }
})()
