importScript('../misc/init.js')
;(function () {
  options.logSubTest('serialport.js')

  const { powerController } = deviceManager.getSupportedPeripherals()
  if (powerController === null) {
    logger.info('SKIPPED: No PMU device, test skipped')
    return
  }
  if (powerController.manufacturer !== 'ardent') {
    logger.info('SKIPPED: Ardent device not found, test skipped')
    return
  }

  const unexpected = new Error("It isn't failed")
  let result = 0

  if (!options.get('logger_serialport_created')) {
    logger.create('serialport_test', 'serial_test.log')
    options.set('logger_serialport_created', true)
  }

  const devices = ftdi.getDeviceList({
    vendor: 0x0403,
    product: 0x6001
  })
  const serialNumbers = devices.map(device => device.serial)
  logger.info(`PASS: Successfully listed all FTDI devices: ${serialNumbers}`)

  if (devices.length === 0) {
    logger.info('SKIPPED: No PMU device, test skipped')
    return
  }

  const { port } = deviceManager.getPortInfo()
  const { serial } = devices.filter(device =>
    device.serial.endsWith(`-${port}`)
  )[0]

  logger.info('SerialPort Open with serial: ' + serial)
  const idx = serialport.open('ftdi', {
    baudRate: 115200,
    vendor: 0x0403,
    product: 0x6001,
    interface: 1,
    serial,
    newline: '\n',
    readInterval: 57
  })
  logger.info(`PASS: Successfully opend serialport index: ${idx}`)

  serialport.pipe(idx, 'serialport_test')
  logger.info('PASS: Successfully piped serialport to a log file')

  serialport.send(idx, Buffer.from('\u0002pmu(measual)\u0003'))
  logger.info('PASS: Successfully sent a message "pmu(measual)"')

  result = serialport.wait(idx, { patterns: ['VOLT'] })
  logger.info(
    `PASS: Successfully matched data using wait with pattern, ${result}`
  )

  serialport.send(idx, Buffer.from('\u0002pmu(measual)\u0003'))
  logger.info('PASS: Successfully sent a message "pmu(measual)"')

  try {
    result = serialport.wait(idx, { patterns: ['wrong!@'], timeoutMs: 2000 })
    throw unexpected
  } catch (err) {
    if (err === unexpected) {
      throw unexpected
    }
    logger.info(
      `PASS: Successfully received expected exception, ${err.message}`
    )
  }

  result = serialport.wait(idx, { patterns: [/.*VOLT.*/] })
  logger.info(
    `PASS: Successfully matched data using wait with regex, ${result}`
  )

  let buffer = serialport.getReadBuffer(idx)
  if (buffer.length <= 0) {
    throw new Error('buffer should not be an empty string')
  }
  logger.info(`PASS: Successfully read serialport read buffer`)

  serialport.flushReadBuffer(idx)
  logger.info(`PASS: Successfully flushed read buffer`)

  buffer = serialport.getReadBuffer(idx)
  if (buffer.length != 0) {
    throw new Error('buffer should be an empty string')
  }
  logger.info(`PASS: Successfully read serialport read buffer`)

  serialport.unpipe(idx)
  logger.info('PASS: Successfully unpiped')

  serialport.close(idx)
  logger.info('PASS: Successfully closed')

  try {
    result = serialport.send(idx, Buffer.from('\u0002pmu(measual)\u0003'))
    throw unexpected
  } catch (err) {
    if (err === unexpected) {
      throw unexpected
    }
    logger.info(
      `PASS: Successfully received expected exception, ${err.message}`
    )
  }

  try {
    result = serialport.wait(idx, { patterns: ['VOLT'], timeoutMs: 2000 })
    throw unexpected
  } catch (err) {
    if (err === unexpected) {
      throw unexpected
    }
    logger.info(
      `PASS: Successfully received expected exception, ${err.message}`
    )
  }
})()
