importScript('../misc/init.js')
;(function () {
  options.logSubTest('tcp.js')

  const targetPort = 9000 + utility.systemInfo().port

  tcp.startEchoServer(targetPort)

  let connectionId = tcp.open('localhost', targetPort)
  logger.info('PASS: Successfully created a TCP connection')

  let data = tcp.read(connectionId, 5)
  if (data.length !== 0) {
    throw new Error(`Unexpected data ${data}`)
  }
  logger.info('PASS: Received expected data (null)')

  tcp.write(connectionId, 'hello')
  logger.info('PASS: Successfully sent data to a TCP connection')

  utility.sleep(1000)

  const bytes = tcp.getReadableBytes(connectionId)
  if (bytes !== 5) {
    throw new Error('Failed to get expected readable data length')
  }
  logger.info(`PASS: Received expected data size (${bytes})`)

  data = tcp.read(connectionId, 5)
  if (data.toString() !== 'hello') {
    throw new Error(`Unexpected data ${data}`)
  }
  logger.info('PASS: Received expected data (hello)')

  tcp.write(connectionId, 'hello')
  data = tcp.read(connectionId, 5, { waitForRequestedData: true })
  if (data.toString() !== 'hello') {
    throw new Error(`Unexpected data ${data}`)
  }
  logger.info('PASS: Received expected data using options.waitForRequestedData')

  tcp.close(connectionId)
  logger.info('PASS: Successfully closed the TCP connection')

  const unexpectedError = new Error('This should not be triggered')
  try {
    data = tcp.read(connectionId, 5)
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('Invalid Connection')) {
      throw new Error('Did not receive an expected exception')
    } else {
      logger.info(
        'PASS: Received an expected exception (Invalid Connection ID)'
      )
    }
  }

  tcp.stopEchoServer()

  try {
    connectionId = tcp.open('localhost', targetPort)
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError || !e.message.includes('Failed to connect')) {
      throw new Error('Did not receive an expected exception')
    } else {
      logger.info('PASS: Received an expected exception (Failed to connect)')
    }
  }
})()
