/* globals importScript, logger, utility, options */
importScript('../misc/init.js')
;(function () {
  options.logSubTest('utility.js')

  const text = options.loadFile()
  if (text !== 'helloworld') {
    throw new Error('loadFile did not return correct data')
  }
  logger.info('PASS: Successfully read file "helloworld"')

  const result1 = utility.exec('bash ../misc/test.sh')
  if (result1.stdout !== 'hello world\n') {
    throw new Error(`Read unexpected value ${result1.stdout}`)
  }
  logger.info('PASS: Successfully executed exec("bash misc/test.sh")')

  const result2 = utility.exec('bash test.sh', { cwd: '../misc' })
  if (result2.stdout !== 'hello world\n') {
    throw new Error(`Read unexpected value ${result2.stdout}`)
  }
  logger.info('PASS: Successfully execute exec("bash test.sh", {cwd:"misc"})')

  options.runScriptInFunction()
  logger.info('PASS: Successfully ran a script in a function')

  const filename = `temp-${Date.now()}`
  const filepath = `/tmp/${filename}`
  utility.exec(`echo -n hello > ${filepath}`)
  logger.info('PASS: Created a temp file using exec')

  const destFile = 'temp.txt'
  utility.copyFile(filepath, destFile)
  logger.info(
    'PASS: Successfully copied the temp file to the log dir as temp.txt'
  )

  const result3 = utility.readFile(destFile).toString()
  if (result3 !== 'hello') {
    throw new Error(`${destFile} has an invalid value`)
  }
  logger.info('PASS: Successfully read the copied file and the context matched')

  utility.copyFile(filepath)
  logger.info(
    'PASS: Successfully copied the temp file to the log dir using the same file name'
  )

  const result4 = utility.readFile(filename).toString()
  if (result4 !== 'hello') {
    throw new Error(`${filename} has an invalid value`)
  }
  logger.info('PASS: Successfully read the copied file and the context matched')

  const taskContext = utility.getTaskInfo()
  const expectedProps = [
    'entryScript',
    'startTime',
    'taskId',
    'inputContext',
    'outputContext'
  ]
  if (!expectedProps.every(prop => prop in taskContext)) {
    throw new Error(
      'Missing properties from the result returned from utility.getTaskInfo()'
    )
  }
  logger.info('PASS: Successfully executed utility.getTaskInfo()')

  utility.setOutputContext({ output: 'context' })
  const outputContext = utility.getTaskInfo().outputContext
  if (outputContext.output !== 'context') {
    throw new Error(
      `Missing expected output context. Context = ${JSON.stringify(
        outputContext
      )}`
    )
  }
  logger.info('PASS: Successfully executed utility.setOutputContext()')

  const urlLatestDatabaseVersion =
    'https://storage.googleapis.com/release-iobc-services/postgrest/latest'
  const response = utility.fetchUrl(urlLatestDatabaseVersion)
  const statusCode = response.getStatusCode()
  if (statusCode !== 200) {
    throw new Error(`Received invalid status code, ${statusCode}`)
  }
  const version = response.getContentText().trim()
  const match = version.match(/[0-9]{2}[.][0-9]{2}([.][0-9])?/)
  if (match === null) {
    throw new Error(`Received invalid version, ${version}`)
  }
  logger.info(
    'PASS: Successfully executed utility.fetchUrl() with text response'
  )

  const urlDatabaseTar =
    'https://storage.googleapis.com/release-iobc-services/database/22.09/database.tar'
  const expectedHash = '33356a66c258825033d01d0910efd58b'
  const response2 = utility.fetchUrl(urlDatabaseTar)
  const receivedHash = utility.computeHash('md5', response2.getContentBuffer())
  if (expectedHash !== receivedHash) {
    throw new Error('The hash for the received data is invalid')
  }
  logger.info(
    'PASS: Successfully executed utility.fetchUrl() with binary response'
  )
})()
