importScript('../misc/init.js')
;(function () {
  options.logSubTest('workload_basic_ignore_error.js')

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const qid = nvme.createQueuePair()

  const opc = 2 // Read
  const sc = 0x81
  const sct = 2
  nvme.setErrorInjection(qid, opc, sct, sc)

  const result = nvme.startWorkloadGenerator({
    qid,
    queueDepth: 32,
    readPercent: 100,
    duration: 1,
    ignoreError: [{ sct: sct, sc: sc }]
  })
  if (result.errorHistory.length !== 1) {
    throw new Error('Did not receive expected error')
  }
  if (result.errorHistory[0].sc !== sc) {
    throw new Error('Did not receive expected error')
  }
  if (result.errorHistory[0].sct !== sct) {
    throw new Error('Did not receive expected error')
  }
  nvme.deleteQueuePair(qid)
  logger.info('PASS: Ignored error when ignoreError is set')
})()
