importScript('/lib/nvme/index.js')
importScript('../misc/init.js')
;(function () {
  options.initDebugLog()

  options.logSubTest('workload_basic_range_list_verify_buffer.js')

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const nsid = 1
  const qid = nvme.createQueuePair()
  const { size: capacity, lbaSize } = nvme.getNamespaceInfo(nsid)
  logger.info('testDebug', `Capacity: ${capacity}`)

  const startLba = capacity - 8
  const numBlocks = 8

  logger.info('testDebug', `Writing LBA ${startLba} for ${numBlocks} blocks`)
  nvmeExt.write(qid, startLba, numBlocks)

  logger.info('testDebug', `Reading LBA ${startLba} for ${numBlocks} blocks`)
  const { buffer: buf4 } = nvmeExt.read(qid, startLba, numBlocks)
  for (let i = 0; i < numBlocks; i += 1) {
    const offset = i * lbaSize
    const currentLba = startLba + i
    const currentLbaHigh = Number(BigInt(currentLba) >> 32n)
    const currentLbaLow = Number(BigInt(currentLba) & 0xffffffffn)
    if (buf4.readUInt32BE(offset + 0) !== currentLbaHigh) {
      throw new Error(`LBA(${currentLba})[4:7] must equal to ${currentLbaHigh}`)
    }
    if (buf4.readUInt32BE(offset + 4) !== currentLbaLow) {
      throw new Error(`LBA(${currentLba})[0:3] must equal to ${currentLbaLow}`)
    }
  }
  logger.info('PASS: Validated data generated by nvmeExt.write')

  const workloadLoops = 1000
  const targetLbaRange = [startLba, startLba + 2, startLba + 4]
  nvme.startWorkloadGenerator({
    nsid: 1,
    queueDepth: 1024,
    xferSize: lbaSize,
    loops: workloadLoops,
    range: targetLbaRange,
    readPercent: 0,
    workload: 'random'
  })
  const { buffer: buf3 } = nvmeExt.read(qid, startLba, numBlocks)
  for (let i = 0; i < numBlocks; i += 1) {
    const offset = i * lbaSize
    const currentLba = startLba + i
    const currentLbaHigh = Number(BigInt(currentLba) >> 32n)
    const currentLbaLow = Number(BigInt(currentLba) & 0xffffffffn)
    const shouldChange = targetLbaRange.includes(currentLba)

    const highChanged = buf3.readUInt32BE(offset + 0) !== currentLbaHigh
    if (shouldChange ^ highChanged) {
      throw new Error(
        `LBA(${currentLba})[4:7] must ${
          shouldChange ? 'not' : ''
        }equal to ${currentLbaHigh}`
      )
    }

    const lowChanged = buf3.readUInt32BE(offset + 4) !== currentLbaLow
    if (shouldChange ^ lowChanged) {
      throw new Error(
        `LBA(${currentLba})[0:3] must ${
          shouldChange ? 'not' : ''
        }equal to ${currentLbaLow}`
      )
    }
  }
  logger.info('PASS: Validated data generated by Array-based range')

  nvme.deleteQueuePair(qid)
})()
