importScript('../misc/init.js')
;(function () {
  options.logSubTest('workload_multi_range.js')

  nvme.probeController()
  logger.info('PASS: Succesfully connected to NVMe controller')

  const nsid = 1
  const { size: capacity, lbaSize } = nvme.getNamespaceInfo(nsid)
  const unexpectedError = new Error('This should not be triggered')
  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info('PASS: Exception trigger when options.ranges is an empty array')

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          startLba: 0,
          size: 0,
          probability: 1,
          readPercent: 100,
          xfers: [
            {
              size: lbaSize,
              probability: 1
            },
            {
              size: lbaSize * 8,
              probability: 1
            }
          ]
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info('PASS: Exception trigger when options.ranges[].size is 0')

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          startLba: 0,
          size: lbaSize,
          probability: 1,
          readPercent: 100,
          xfers: []
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception trigger when options.ranges[].xfers is an empty array'
  )

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          startLba: capacity,
          size: lbaSize,
          probability: 1,
          readPercent: 100,
          xfers: []
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info('PASS: Exception trigger when options.ranges[].startLba >= NSZE')

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          startLba: 0,
          size: capacity + 1,
          probability: 1,
          readPercent: 100,
          xfers: []
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info('PASS: Exception trigger when options.ranges[].size > NSZE')

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          startLba: 0,
          size: 1024,
          probability: 1,
          readPercent: 100,
          xfers: [
            {
              size: 0,
              probability: 1
            }
          ]
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info('PASS: Exception trigger when options.ranges[].xfers[].size is 0')

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          startLba: 0,
          size: 1024,
          probability: 1,
          readPercent: 100,
          xfers: [
            {
              size: 512,
              probability: 0
            }
          ]
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception trigger when options.ranges[].xfers[].probability is 0'
  )

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          startLba: 0,
          size: 1024,
          probability: 1,
          readPercent: 100,
          xfers: [
            {
              size: 511,
              probability: 1
            }
          ]
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception trigger when options.ranges[].xfers[].size is not multiples of FLBAS'
  )

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          alignment: 0,
          startLba: 12,
          size: 1024,
          probability: 1,
          readPercent: 100,
          xfers: [
            {
              size: 512,
              probability: 1
            },
            {
              size: 32 * 1024,
              probability: 1
            }
          ]
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception trigger when options.ranges[].startLba is unaligned to max(xfers.size)'
  )

  try {
    nvme.startWorkloadGenerator({
      type: 'multiRange',
      queueDepth: 1024,
      loops: 1,
      ranges: [
        {
          alignment: 0,
          startLba: 0,
          size: 12,
          probability: 1,
          readPercent: 100,
          xfers: [
            {
              size: 512,
              probability: 1
            },
            {
              size: 32 * 1024,
              probability: 1
            }
          ]
        }
      ],
      duration: 10
    })
    throw unexpectedError
  } catch (e) {
    if (e === unexpectedError) {
      throw new Error('Did not receive an expected exception')
    }
  }
  logger.info(
    'PASS: Exception trigger when options.ranges[].size is unaligned to max(xfers.size)'
  )

  nvme.startWorkloadGenerator({
    type: 'multiRange',
    queueDepth: 1024,
    loops: 1,
    ranges: [
      {
        alignment: 8,
        startLba: 0,
        size: 32 * 1024 * 1024,
        probability: 1,
        readPercent: 50,
        xfers: [
          {
            size: lbaSize,
            probability: 1
          },
          {
            size: lbaSize * 8,
            probability: 1
          }
        ]
      }
    ],
    duration: 1
  })
  logger.info('PASS: Multi-Range mode is functional')
})()
