nvmeExt.write = function (qid, startLba, numBlocks, options) {
  startLba = BigInt(startLba)
  let { buffer = null, nsid = 1 } = options || {}
  const { lbaSize } = nvme.getNamespaceInfo(nsid)
  const startLbaHigh = Number(startLba >> 32n)
  const startLbaLow = Number(startLba & 0xffffffffn)

  if (buffer === null) {
    buffer = Buffer.alloc(numBlocks * lbaSize, 0)
    for (let blockIndex = 0; blockIndex < numBlocks; blockIndex += 1) {
      const dataHigh = Number((startLba + BigInt(blockIndex)) >> 32n)
      const dataLow = Number((startLba + BigInt(blockIndex)) & 0xffffffffn)
      for (let byteIndex = 0; byteIndex < lbaSize; byteIndex += 8) {
        const offset = byteIndex + blockIndex * lbaSize
        buffer.writeUInt32BE(dataHigh, offset)
        buffer.writeUInt32BE(dataLow, offset + 4)
      }
    }
  }

  const cqe = nvme.sendNvmCommand(
    qid,
    {
      opc: 0x01,
      nsid,
      cdw10: startLbaLow,
      cdw11: startLbaHigh,
      cdw12: numBlocks - 1
    },
    buffer,
    true
  )
  return { cqe, buffer }
}

nvmeExt.read = function (qid, startLba, numBlocks, options) {
  const { nsid = 1 } = options || {}
  startLba = BigInt(startLba)
  const { lbaSize } = nvme.getNamespaceInfo(nsid)
  const startLbaHigh = Number(startLba >> 32n)
  const startLbaLow = Number(startLba & 0xffffffffn)
  const buffer = Buffer.alloc(numBlocks * lbaSize, 0)
  const cqe = nvme.sendNvmCommand(
    qid,
    {
      opc: 0x02,
      nsid: 1,
      cdw10: startLbaLow,
      cdw11: startLbaHigh,
      cdw12: numBlocks - 1
    },
    buffer,
    false
  )
  return { cqe, buffer }
}
