function preconditionSequentialWrite () {
  logger.info('Preconditioning sequential performance test')
  logger.info('Prform sequential write twice')
  nvme.startWorkloadGenerator({
    nsid: 1,
    queueDepth: 1024,
    xferSize: 128 * 1024,
    loops: 2,
    readPercent: 0,
    workload: 'sequential',
    range: '100%'
  })
}

function preconditionRandomWrite () {
  logger.info('Preconditioning random performance test')
  logger.info('Perform random write twice')
  nvme.startWorkloadGenerator({
    nsid: 1,
    queueDepth: 1024,
    xferSize: 4096,
    loops: 2,
    readPercent: 0,
    workload: 'random',
    range: '100%'
  })
}

function measureRandomPerformance (readOrWrite, logName, duration = 60) {
  for (const qd of [1, 32, 64, 128, 256, 512, 1024]) {
    logger.info(`Meausre random ${readOrWrite}, XferSize=4096b, QD=${qd}`)
    const res = nvme.startWorkloadGenerator({
      nsid: 1,
      queueDepth: qd,
      xferSize: 4096,
      duration,
      loops: 1,
      readPercent: readOrWrite === 'read' ? 100 : 0,
      workload: 'random',
      range: '100%',
      features: {
        histogram: {
          enabled: true
        }
      }
    })
    logger.info(logName, JSON.stringify(res))
  }
}

function measureSequentialPerformance (readOrWrite, logName, duration) {
  for (const io of [1024 * 32, 1024 * 64, 1024 * 128]) {
    logger.info(`Sequential ${readOrWrite}, XferSize=${io}b, QD = 256`)
    const res = nvme.startWorkloadGenerator({
      nsid: 1,
      queueDepth: 256,
      xferSize: io,
      duration,
      loops: 1,
      readPercent: readOrWrite === 'read' ? 100 : 0,
      workload: 'sequential',
      range: '100%'
    })
    logger.info(logName, JSON.stringify(res))
  }
}
